/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.render;

import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.client.render.PatternColors;
import at.petrak.hexcasting.client.render.PatternRenderer;
import at.petrak.hexcasting.client.render.PatternSettings;
import at.petrak.hexcasting.common.blocks.akashic.BlockAkashicBookshelf;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicBookshelf;
import at.petrak.hexcasting.common.blocks.circles.BlockEntitySlate;
import at.petrak.hexcasting.common.blocks.circles.BlockSlate;
import at.petrak.hexcasting.common.entities.EntityWallScroll;
import javax.annotation.Nullable;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;

public class WorldlyPatternRenderHelpers {
    public static final PatternSettings SCROLL_SETTINGS = new PatternSettings("scroll", PatternSettings.PositionSettings.paddedSquare(0.125), PatternSettings.StrokeSettings.fromStroke(0.05), PatternSettings.ZappySettings.STATIC);
    public static final PatternSettings READABLE_SCROLL_SETTINGS = new PatternSettings("scroll_readable", PatternSettings.PositionSettings.paddedSquare(0.125), PatternSettings.StrokeSettings.fromStroke(0.05), PatternSettings.ZappySettings.READABLE);
    public static final PatternSettings WORLDLY_SETTINGS = new PatternSettings("worldly", PatternSettings.PositionSettings.paddedSquare(0.125), PatternSettings.StrokeSettings.fromStroke(0.05), PatternSettings.ZappySettings.STATIC);
    public static final PatternSettings WORLDLY_SETTINGS_WOBBLY = new PatternSettings("wobbly_world", PatternSettings.PositionSettings.paddedSquare(0.125), PatternSettings.StrokeSettings.fromStroke(0.05), PatternSettings.ZappySettings.WOBBLY);
    private static final int[] WALL_ROTATIONS = new int[]{180, 270, 0, 90};
    private static final class_2382[] SLATE_FACINGS = new class_2382[]{new class_2382(0, -1, 0), new class_2382(-1, -1, 0), new class_2382(-1, -1, 1), new class_2382(0, -1, 1)};
    private static final class_243[] WALL_NORMALS = new class_243[]{new class_243(0.0, 0.0, -1.0), new class_243(-1.0, 0.0, 0.0), new class_243(0.0, 0.0, -1.0), new class_243(-1.0, 0.0, 0.0)};
    private static final class_2382[] SLATE_FLOORCEIL_FACINGS = new class_2382[]{new class_2382(0, 0, 0), new class_2382(1, 0, 0), new class_2382(1, 0, 1), new class_2382(0, 0, 1)};
    private static final class_2382[] BLOCK_FACINGS = new class_2382[]{new class_2382(0, -1, 1), new class_2382(0, -1, 0), new class_2382(-1, -1, 0), new class_2382(-1, -1, 1)};

    public static void renderPatternForScroll(HexPattern pattern, EntityWallScroll scroll, class_4587 ps, class_4597 bufSource, int light, int blockSize, boolean showStrokeOrder) {
        ps.method_22903();
        ps.method_46416((float)(-blockSize) / 2.0f, (float)(-blockSize) / 2.0f, 0.03125f);
        ps.method_23760().method_23762().mul((Matrix3fc)new Matrix3f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f));
        WorldlyPatternRenderHelpers.renderPattern(pattern, showStrokeOrder ? READABLE_SCROLL_SETTINGS : SCROLL_SETTINGS, showStrokeOrder ? PatternColors.READABLE_SCROLL_COLORS : PatternColors.DEFAULT_PATTERN_COLOR, scroll.method_6896().hashCode(), ps, bufSource, null, null, light, blockSize);
        ps.method_22909();
    }

    public static void renderPatternForSlate(BlockEntitySlate tile, HexPattern pattern, class_4587 ps, class_4597 buffer, int light, class_2680 bs) {
        boolean isOnWall = bs.method_11654(BlockSlate.ATTACH_FACE) == class_2738.field_12471;
        boolean isOnCeiling = bs.method_11654(BlockSlate.ATTACH_FACE) == class_2738.field_12473;
        int facing = ((class_2350)bs.method_11654((class_2769)BlockSlate.FACING)).method_10161();
        boolean wombly = (Boolean)bs.method_11654((class_2769)BlockSlate.ENERGIZED);
        ps.method_22903();
        class_243 normal = null;
        if (isOnWall) {
            ps.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            class_2382 tV = SLATE_FACINGS[facing % 4];
            ps.method_46416((float)tV.method_10263(), (float)tV.method_10264(), (float)tV.method_10260());
            ps.method_22907(class_7833.field_40716.rotationDegrees((float)WALL_ROTATIONS[facing % 4]));
            normal = WALL_NORMALS[facing % 4];
        } else {
            class_2382 tV = SLATE_FLOORCEIL_FACINGS[facing % 4];
            ps.method_46416((float)tV.method_10263(), (float)tV.method_10264(), (float)tV.method_10260());
            ps.method_22907(class_7833.field_40716.rotationDegrees((float)(facing * -90)));
            ps.method_22907(class_7833.field_40714.rotationDegrees((float)(90 * (isOnCeiling ? -1 : 1))));
            if (isOnCeiling) {
                ps.method_46416(0.0f, -1.0f, 1.0f);
            }
        }
        WorldlyPatternRenderHelpers.renderPattern(pattern, wombly ? WORLDLY_SETTINGS_WOBBLY : WORLDLY_SETTINGS, wombly ? PatternColors.SLATE_WOBBLY_PURPLE_COLOR : PatternColors.DEFAULT_PATTERN_COLOR, tile.method_11016().hashCode(), ps, buffer, normal, null, light, 1);
        ps.method_22909();
    }

    public static void renderPatternForAkashicBookshelf(BlockEntityAkashicBookshelf tile, HexPattern pattern, class_4587 ps, class_4597 buffer, int light, class_2680 bs) {
        int facing = ((class_2350)bs.method_11654((class_2769)BlockAkashicBookshelf.FACING)).method_10161();
        ps.method_22903();
        ps.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        class_2382 tV = BLOCK_FACINGS[facing % 4];
        ps.method_46416((float)tV.method_10263(), (float)tV.method_10264(), (float)tV.method_10260());
        ps.method_22907(class_7833.field_40716.rotationDegrees((float)WALL_ROTATIONS[facing % 4]));
        int actualLight = class_761.method_23794((class_1920)tile.method_10997(), (class_2338)tile.method_11016().method_10093((class_2350)bs.method_11654((class_2769)BlockAkashicBookshelf.FACING)));
        WorldlyPatternRenderHelpers.renderPattern(pattern, WORLDLY_SETTINGS, PatternColors.DEFAULT_PATTERN_COLOR, tile.method_11016().hashCode(), ps, buffer, WALL_NORMALS[facing % 4].method_18805(-1.0, -1.0, -1.0), Float.valueOf(-0.02f), actualLight, 1);
        ps.method_22909();
    }

    public static void renderPattern(HexPattern pattern, PatternSettings patSets, PatternColors patColors, double seed, class_4587 ps, class_4597 bufSource, class_243 normal, @Nullable Float zOffset, int light, int blockSize) {
        ps.method_22903();
        float z = zOffset != null ? zOffset.floatValue() : -0.0725f;
        normal = normal != null ? normal : new class_243(0.0, 0.0, -1.0);
        ps.method_46416(0.0f, 0.0f, z);
        ps.method_22905((float)blockSize, (float)blockSize, 1.0f);
        class_4587 noNormalInv = new class_4587();
        noNormalInv.method_22905(1.0f, 1.0f, -1.0f);
        ps.method_34425(noNormalInv.method_23760().method_23761());
        PatternRenderer.renderPattern(pattern, ps, new PatternRenderer.WorldlyBits(bufSource, light, normal), patSets, patColors, seed, blockSize * 512);
        ps.method_22909();
    }
}

